/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.HWSvrSocket;
import java.util.Calendar;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspTypeVersion {
    private UnsignedInt8 mVersionFamily;
    private UnsignedInt8 mEncloserType;
    private UnsignedInt16 mMajorVersion;
    private UnsignedInt16 mMinorVersion;
    private UnsignedInt8 mFspGardFlag;
    private UnsignedInt8 mRole;
    private String mModelType;
    private String mSerialNumber;
    private String mBrand;
    private long mTimeStamp;
    private static final String GET_TYPE_VERSION = "GET_ENCLOSURE_TYPE_AND_INTERFACE_VERSION_NUMBER";
    private static final String VERSION_FAMILY = "FAMILY";
    private static final String ENCLOSURE_TYPE = "TYPE";
    private static final String MAJOR_VERSION = "MAJOR_VERSION";
    private static final String MINOR_VERSION = "MINOR_VERSION";
    private static final String FSP_GARD_FLAG = "GRAD_FLAG";
    private static final String MASTER_SLAVE_ROLE = "MASTER_SLAVE";
    private static final String MODEL_TYPE = "TYPE_MODEL";
    private static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    private static final String BRAND = "BRAND";
    private static final String YEAR = "YEAR";
    private static final String MONTH = "MONTH";
    private static final String DAY = "DAY";
    private static final String HOUR = "HOUR";
    private static final String MINUTE = "MINUTE";
    private static final String SECOND = "SECOND";
    private static final String MICROSECOND = "MICRO_SECOND";
    private static final String TOOL_TYPE_STR = new Integer(1213023008).toString();

    static FspTypeVersion getTypeVersionCmd(FSPCmdMgr fSPCmdMgr) throws PIHscServerException {
        Hashtable hashtable = fSPCmdMgr.doFSPCommand(GET_TYPE_VERSION, FspTypeVersion.getArguments());
        System.out.println("getTypeVersion --> response = " + hashtable);
        return new FspTypeVersion(hashtable);
    }

    public FspTypeVersion(Hashtable hashtable) {
        this.mVersionFamily = (UnsignedInt8)hashtable.get(VERSION_FAMILY);
        this.mEncloserType = (UnsignedInt8)hashtable.get(ENCLOSURE_TYPE);
        this.mMajorVersion = (UnsignedInt16)hashtable.get(MAJOR_VERSION);
        this.mMinorVersion = (UnsignedInt16)hashtable.get(MINOR_VERSION);
        this.mFspGardFlag = (UnsignedInt8)hashtable.get(FSP_GARD_FLAG);
        this.mRole = (UnsignedInt8)hashtable.get(MASTER_SLAVE_ROLE);
        this.mModelType = (String)hashtable.get(MODEL_TYPE);
        this.mSerialNumber = (String)hashtable.get(SERIAL_NUMBER);
        this.mBrand = (String)hashtable.get(BRAND);
        int n = ((UnsignedInt16)hashtable.get(YEAR)).intValue();
        int n2 = ((UnsignedInt8)hashtable.get(MONTH)).intValue();
        int n3 = ((UnsignedInt8)hashtable.get(DAY)).intValue();
        int n4 = ((UnsignedInt8)hashtable.get(HOUR)).intValue();
        int n5 = ((UnsignedInt8)hashtable.get(MINUTE)).intValue();
        int n6 = ((UnsignedInt8)hashtable.get(SECOND)).intValue();
        int n7 = ((UnsignedInt32)hashtable.get(MICROSECOND)).intValue();
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3, n4, n5, n6);
        this.mTimeStamp = calendar.getTimeInMillis() + (long)(n7 % 1000);
    }

    public static String[] getArguments() {
        String string = HWSvrSocket.getInstance().getHmcId();
        String string2 = new Integer(string.length()).toString();
        return new String[]{"2", TOOL_TYPE_STR, string2, string};
    }

    public static String getCommand() {
        return GET_TYPE_VERSION;
    }

    public String getVersionStr() {
        return "" + this.mVersionFamily + "." + this.mMajorVersion + "." + this.mMinorVersion;
    }

    public String getMtms() {
        return this.mModelType + "*" + this.mSerialNumber;
    }
}

